<?php
/**
 * GeoDirectory Detail User Actions Widget
 *
 * @since 2.0.0
 *
 * @package GeoDirectory
 */

/**
 * GeoDir_Widget_Detail_User_Actions class.
 *
 * @since 2.0.0
 */
class GDF_Widget_Welcome_Login extends WP_Super_Duper {

	public $arguments;

	/**
	 * Sets up a new Detail User Actions widget instance.
	 *
	 * @since 2.0.0
	 * @access public
	 */
	public function __construct() {

		$options = array(
			'textdomain'     => GEODIRECTORY_FRAMEWORK,
			'block-icon'     => 'admin-site',
			'block-category' => 'widgets',
			'block-keywords' => "['author','login','geo']",
			'class_name'     => __CLASS__,
			'base_id'        => 'gdf_welcome_login', // this us used as the widget id and the shortcode id.
			'name'           => __( 'GDF > Welcome Login', 'geodirectory_framework' ), // the name of the widget.
			'widget_ops'     => array(
				'classname'              => 'geodir-author-actions',
				// widget class
				'description'            => esc_html__( 'Show a welcome message and a login link. (designed for "Header Right" widget area)', 'geodirectory_framework' ),
				// widget description
			),
			'arguments'      => array(
//				'show_register'  => array(
//					'title' => __('Hide edit', 'geodirectory_framework'),
//					'desc' => __('Hide the edit action.', 'geodirectory_framework'),
//					'type' => 'checkbox',
//					'value'=> '1',
//					'default'=> '0',
//					'desc_tip' => true,
//					'advanced' => true
//				)
			)
		);

		parent::__construct( $options );
	}

	/**
	 * The Super block output function.
	 *
	 * @param array $args
	 * @param array $widget_args
	 * @param string $content
	 *
	 * @return mixed|string|void
	 */
	public function output( $args = array(), $widget_args = array(), $content = '' ) {
		global $post;

		$output = '';
		ob_start();

		global $current_user;
		$login_url  = wp_login_url( get_permalink() );
		$logout_url = wp_logout_url( home_url() );

		?>
		<div class="gdf_welcome_login_wrap">
		<ul class="gdf_welcome_login"><?php
			if ( get_current_user_id() ) {
				$display_name = $current_user->data->display_name;
				$author_link = get_author_posts_url( $current_user->data->ID, $current_user->data->user_nicename);
				?>
				<li class="gdf-welcome"><span><?php _e( 'Welcome', 'geodirectory_framework' ); ?>, </span> <a
						href="<?php echo esc_url( $author_link ); ?>"
						title="<?php echo $display_name; ?>">  <?php echo $display_name; ?></a></li>
				<li class="gdf-userin"><a href="<?php echo $logout_url; ?>"
				                      class="signin"><?php _e( 'Logout', 'geodirectory_framework' ); ?></a></li>
			<?php } else { ?>
				<li class="gdf-welcome"><span><?php _e( 'Welcome', 'geodirectory_framework' ); ?>
						, <strong><?php _e( 'Guest', 'geodirectory_framework' ); ?></strong></span></li>
				<li class="gdf-userin"><a href="<?php echo $login_url; ?>"
				                      class="signin"><?php _e( 'Sign in', 'geodirectory_framework' ); ?></a></li>
			<?php } ?>
		</ul>
		</div>
		<?php

		$output .= ob_get_clean();


		return $output;
	}
}

